/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import automata.State;
import automata.fsa.FSATransition;
import automata.fsa.FiniteStateAutomaton;
import gui.environment.FrameFactory;
import gui.environment.Universe;
import gui.regular.ConvertToAutomatonPane;
import gui.viewer.AutomatonPane;
import java.awt.Component;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.JOptionPane;
import regular.Discretizer;

public class REToFSAController {
    private ConvertToAutomatonPane convertPane;
    private FiniteStateAutomaton automaton;
    private Set toDo = new HashSet();
    private Set toDoTransitions = new HashSet();
    private int action = 0;
    private FSATransition transition = null;
    private int transitionNeeded = 0;
    private FSATransition[] replacements = null;
    private boolean catBeginMade = false;
    private boolean catEndMade = false;
    private static final int DEPARENS = 1;
    private static final int DESTAR = 2;
    private static final int DEOR = 3;
    private static final int DECAT = 4;

    public REToFSAController(ConvertToAutomatonPane pane, FiniteStateAutomaton automaton) {
        this.convertPane = pane;
        this.automaton = automaton;
        FSATransition t = (FSATransition)automaton.getTransitions()[0];
        if (this.requiredAction(t.getLabel()) != 0) {
            this.toDo.add(t);
        }
        this.convertPane.exportAction.setEnabled(false);
        this.nextStep();
    }

    private int requiredAction(String expression) {
        if (expression.length() <= 1) {
            return 0;
        }
        if (Discretizer.or(expression).length > 1) {
            return 3;
        }
        if (Discretizer.cat(expression).length > 1) {
            return 4;
        }
        if (expression.charAt(expression.length() - 1) == '*') {
            return 2;
        }
        if (expression.charAt(0) == '(' && expression.charAt(expression.length() - 1) == ')') {
            return 1;
        }
        throw new IllegalArgumentException("Expression " + expression + " not recognized!");
    }

    private FSATransition[] replaceTransition(FSATransition transition, String[] exps) {
        AffineTransform at = new AffineTransform();
        Point pStart = transition.getFromState().getPoint();
        Point pEnd = transition.getToState().getPoint();
        at.translate(pStart.x, pStart.y);
        at.scale(pStart.distance(pEnd), pStart.distance(pEnd));
        at.rotate(Math.atan2(pEnd.y - pStart.y, pEnd.x - pStart.x));
        FSATransition[] t = new FSATransition[exps.length];
        Point2D.Double ps = new Point2D.Double(0.2, 0.0);
        Point2D.Double pe = new Point2D.Double(0.8, 0.0);
        this.automaton.removeTransition(transition);
        int i = 0;
        while (i < exps.length) {
            double y;
            pStart = new Point();
            pEnd = new Point();
            pe.y = ps.y = (y = exps.length > 1 ? ((double)i / ((double)exps.length - 1.0) - 0.5) * 0.5 : 0.0);
            at.transform(ps, pStart);
            at.transform(pe, pEnd);
            pStart.x = Math.max(pStart.x, 20);
            pStart.y = Math.max(pStart.y, 20);
            pEnd.x = Math.max(pEnd.x, 20);
            pEnd.y = Math.max(pEnd.y, 20);
            State s = this.automaton.createState(pStart);
            State e = this.automaton.createState(pEnd);
            t[i] = new FSATransition(s, e, exps[i]);
            this.automaton.addTransition(t[i]);
            if (this.requiredAction(t[i].getLabel()) != 0) {
                this.toDo.add(t[i]);
            }
            ++i;
        }
        return t;
    }

    public void transitionCheck(FSATransition transition) {
        if (this.action != 0) {
            JOptionPane.showMessageDialog(this.convertPane, "We're already in the process of\ndeexpressionifying a transition.", "Already Active", 0);
            return;
        }
        this.action = this.requiredAction(transition.getLabel());
        if (this.action == 0) {
            JOptionPane.showMessageDialog(this.convertPane, "That's as good as it gets.", "No Action Necessary", 0);
            return;
        }
        this.transition = transition;
        this.toDo.remove(transition);
        String label = transition.getLabel();
        switch (this.action) {
            case 1: {
                State s1 = transition.getFromState();
                State s2 = transition.getToState();
                String newLabel = Discretizer.delambda(label.substring(1, label.length() - 1));
                this.automaton.removeTransition(transition);
                FSATransition t = new FSATransition(s1, s2, newLabel);
                this.automaton.addTransition(t);
                if (this.requiredAction(newLabel) != 0) {
                    this.toDo.add(t);
                }
                this.action = 0;
                break;
            }
            case 2: {
                this.replacements = this.replaceTransition(transition, new String[]{Discretizer.delambda(label.substring(0, label.length() - 1))});
                this.transitionNeeded = 4;
                break;
            }
            case 3: {
                this.replacements = this.replaceTransition(transition, Discretizer.or(label));
                this.transitionNeeded = 2 * this.replacements.length;
                break;
            }
            case 4: {
                this.replacements = this.replaceTransition(transition, Discretizer.cat(label));
                this.transitionNeeded = this.replacements.length + 1;
                this.catEndMade = false;
                this.catBeginMade = false;
            }
        }
        this.nextStep();
    }

    private FSATransition lambda(State from, State to) {
        return new FSATransition(from, to, "");
    }

    public void completeStep() {
        if (this.action == 0) {
            Iterator it = this.toDo.iterator();
            FSATransition t = (FSATransition)it.next();
            this.transitionCheck(t);
        }
        State from = this.transition.getFromState();
        State to = this.transition.getToState();
        switch (this.action) {
            case 1: {
                return;
            }
            case 3: {
                int i = 0;
                while (i < this.replacements.length) {
                    this.automaton.addTransition(this.lambda(from, this.replacements[i].getFromState()));
                    this.automaton.addTransition(this.lambda(this.replacements[i].getToState(), to));
                    ++i;
                }
                break;
            }
            case 4: {
                this.automaton.addTransition(this.lambda(from, this.replacements[0].getFromState()));
                int i = 0;
                while (i < this.replacements.length - 1) {
                    this.automaton.addTransition(this.lambda(this.replacements[i].getToState(), this.replacements[i + 1].getFromState()));
                    ++i;
                }
                this.automaton.addTransition(this.lambda(this.replacements[this.replacements.length - 1].getToState(), to));
                break;
            }
            case 2: {
                this.automaton.addTransition(this.lambda(from, this.replacements[0].getFromState()));
                this.automaton.addTransition(this.lambda(this.replacements[0].getToState(), to));
                this.automaton.addTransition(this.lambda(from, to));
                this.automaton.addTransition(this.lambda(to, from));
            }
        }
        this.transitionNeeded = 0;
        this.nextStep();
    }

    public void completeAll() {
        while (this.action != 0 || this.toDo.size() > 0) {
            this.completeStep();
        }
    }

    public void export() {
        FrameFactory.createFrame((FiniteStateAutomaton)this.automaton.clone());
    }

    public void exportToTab() {
        AutomatonPane p = new AutomatonPane(this.automaton);
        this.convertPane.environment.add((Component)p, "Current FA");
        this.convertPane.environment.setActive(p);
    }

    public void transitionCreate(State from, State to) {
        boolean alreadyHere = this.automaton.getTransitionsFromStateToState(from, to).length != 0;
        boolean valid = false;
        block0 : switch (this.action) {
            case 0: {
                JOptionPane.showMessageDialog(this.convertPane, "A transition must be selected with\nthe deexpressionifier tool first.", "Invalid Action", 0);
                return;
            }
            case 3: {
                int i;
                if (from == this.transition.getFromState()) {
                    i = 0;
                    while (i < this.replacements.length) {
                        if (this.replacements[i].getFromState() == to) {
                            valid = true;
                            break;
                        }
                        ++i;
                    }
                }
                if (to != this.transition.getToState()) break;
                i = 0;
                while (i < this.replacements.length) {
                    if (this.replacements[i].getToState() == from) {
                        valid = true;
                        break block0;
                    }
                    ++i;
                }
                break;
            }
            case 4: {
                if (this.automaton.getTransitionsFromState(from).length > 0 || this.automaton.getTransitionsToState(to).length > 0) {
                    if (!alreadyHere) break;
                    valid = true;
                    break;
                }
                int index1 = -1;
                int index2 = -1;
                int i = 0;
                while (i < this.replacements.length) {
                    if (this.replacements[i].getToState() == from) {
                        index1 = i;
                    }
                    if (this.replacements[i].getFromState() == to) {
                        index2 = i;
                    }
                    ++i;
                }
                int step = this.replacements.length + 1 - this.transitionNeeded;
                if (index1 == -1 && from != this.transition.getFromState() || index2 == -1 && to != this.transition.getToState()) break;
                if (index2 == -1) {
                    if (step != this.replacements.length) {
                        JOptionPane.showMessageDialog(this.convertPane, "That may be correct, but the transitions\nmust be connected in order.", "Out of Order", 0);
                        return;
                    }
                    valid = from == this.replacements[this.replacements.length - 1].getToState();
                    break;
                }
                if (step == 0 && index1 != -1 || step > 0 && this.replacements[step - 1].getToState() != from) {
                    JOptionPane.showMessageDialog(this.convertPane, "That may be correct, but the transitions\nmust be connected in order.", "Out of Order", 0);
                    return;
                }
                if (this.replacements[index2].getLabel().equals(this.replacements[step].getLabel())) {
                    FSATransition t = this.replacements[step];
                    this.replacements[step] = this.replacements[index2];
                    this.replacements[index2] = t;
                    valid = true;
                    break;
                }
                valid = false;
                break;
            }
            case 2: {
                if (to == this.transition.getToState() && from == this.transition.getFromState()) {
                    valid = true;
                    break;
                }
                if (from == this.transition.getToState() && to == this.transition.getFromState()) {
                    valid = true;
                    break;
                }
                if (to == this.transition.getToState() && from == this.replacements[0].getToState()) {
                    valid = true;
                    break;
                }
                if (from != this.transition.getFromState() || to != this.replacements[0].getFromState()) break;
                valid = true;
            }
        }
        if (!valid) {
            JOptionPane.showMessageDialog(this.convertPane, "A transition there is invalid.", "Bad Transition", 0);
            return;
        }
        if (alreadyHere) {
            JOptionPane.showMessageDialog(this.convertPane, "A transition exists here.", "Transition Already Exists", 0);
            return;
        }
        FSATransition t = new FSATransition(from, to, "");
        this.automaton.addTransition(t);
        --this.transitionNeeded;
        this.nextStep();
    }

    private void nextStep() {
        if (this.transitionNeeded == 0) {
            if (this.toDo.size() > 0) {
                if (this.action != 0) {
                    this.convertPane.mainLabel.setText("Resolution complete.");
                } else {
                    this.convertPane.mainLabel.setText("Welcome to the converter.");
                }
                this.convertPane.detailLabel.setText(String.valueOf(this.toDo.size()) + " more resolutions needed.");
                this.action = 0;
                return;
            }
            this.action = 0;
            this.convertPane.mainLabel.setText("The automaton is complete.");
            this.convertPane.detailLabel.setText("\"Export\" will put it in a new window.");
            this.convertPane.exportAction.setEnabled(true);
            this.convertPane.doStepAction.setEnabled(false);
            this.convertPane.doAllAction.setEnabled(false);
            return;
        }
        this.convertPane.detailLabel.setText(String.valueOf(this.transitionNeeded) + " more " + Universe.curProfile.getEmptyString() + "-transitions needed.");
        switch (this.action) {
            case 3: {
                this.convertPane.mainLabel.setText("De-oring " + this.transition.getLabel());
                break;
            }
            case 4: {
                this.convertPane.mainLabel.setText("De-concatenating " + this.transition.getLabel());
                break;
            }
            case 2: {
                this.convertPane.mainLabel.setText("De-staring " + this.transition.getLabel());
            }
        }
    }
}

