/*
 * Decompiled with CFR 0.152.
 */
package gui.regular;

import automata.Transition;
import gui.regular.FSAToREController;
import gui.regular.TransitionTableModel;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class TransitionWindow
extends JFrame {
    private FSAToREController controller;
    private Transition[] transitions = new Transition[0];
    private JTable table = new JTable(new TransitionTableModel());

    public TransitionWindow(FSAToREController controller) {
        super("Transitions");
        this.controller = controller;
        this.setSize(250, 400);
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)new JLabel("Select to see what transitions were combined."), "North");
        this.getContentPane().add((Component)new JScrollPane(this.table), "Center");
        this.getContentPane().add((Component)new JButton(new AbstractAction("Finalize"){

            public void actionPerformed(ActionEvent e) {
                TransitionWindow.this.controller.finalizeStateRemove();
            }
        }), "South");
        this.table.getSelectionModel().addListSelectionListener(new ListSelectionListener(){

            public void valueChanged(ListSelectionEvent e) {
                if (TransitionWindow.this.table.getSelectedRowCount() != 1) {
                    TransitionWindow.this.controller.tableTransitionSelected(null);
                    return;
                }
                Transition t = TransitionWindow.this.transitions[TransitionWindow.this.table.getSelectedRow()];
                TransitionWindow.this.controller.tableTransitionSelected(t);
            }
        });
    }

    public Transition[] getTransitions() {
        return this.transitions;
    }

    public void setTransitions(Transition[] transitions) {
        this.transitions = transitions;
        this.table.setModel(new TransitionTableModel(transitions));
    }
}

