/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import automata.State;
import automata.turing.TMSimulator;
import gui.sim.ConfigurationPane;
import gui.sim.ConfigurationSelectionEvent;
import gui.sim.ConfigurationSelectionListener;
import gui.sim.TraceWindow;
import gui.viewer.SelectionDrawer;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Stack;
import javax.swing.JOptionPane;
import javax.swing.JSplitPane;

public class ConfigurationController
implements ConfigurationSelectionListener {
    private ConfigurationPane configurations;
    private AutomatonSimulator simulator;
    private SelectionDrawer drawer;
    private Component component;
    private HashMap configurationToTraceWindow = new HashMap();
    private Configuration[] originalConfigurations = new Configuration[0];
    private static final String NO_CONFIGURATION_ERROR = "Select at least one configuration!";
    private static final String NO_CONFIGURATION_ERROR_TITLE = "No Configuration Selected";
    private static final String FOCUS_CONFIGURATION_ERROR = "JFLAP can only focus on one configuration at a time!";
    private static final String FOCUS_CONFIGURATION_ERROR_TITLE = "Too many configurations selected";

    public ConfigurationController(ConfigurationPane pane, AutomatonSimulator simulator, SelectionDrawer drawer, Component component) {
        this.configurations = pane;
        this.simulator = simulator;
        this.drawer = drawer;
        this.component = component;
        this.changeSelection();
        this.configurations.addSelectionListener(this);
        this.originalConfigurations = this.configurations.getConfigurations();
    }

    public void reset() {
        this.configurations.clear();
        if (this.simulator instanceof TMSimulator) {
            TMSimulator tmSim = (TMSimulator)this.simulator;
            Configuration[] configs = tmSim.getInitialConfigurations(tmSim.getInputStrings());
            int i = 0;
            while (i < configs.length) {
                this.configurations.add(configs[i]);
                ++i;
            }
        } else {
            int i = 0;
            while (i < this.originalConfigurations.length) {
                this.originalConfigurations[i].reset();
                this.configurations.add(this.originalConfigurations[i]);
                ++i;
            }
        }
        this.configurations.validate();
        this.configurations.repaint();
        this.changeSelection();
    }

    public void cleanup() {
        Collection windows = this.configurationToTraceWindow.values();
        Iterator it = windows.iterator();
        while (it.hasNext()) {
            ((TraceWindow)it.next()).dispose();
        }
        this.configurationToTraceWindow.clear();
    }

    public void step(boolean blockStep) {
        Configuration[] configs = this.configurations.getValidConfigurations();
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        HashSet<Configuration> reject = new HashSet<Configuration>();
        this.configurations.clearThawed();
        int i = 0;
        while (i < configs.length) {
            ArrayList next = this.simulator.stepConfiguration(configs[i]);
            if (next.size() == 0) {
                reject.add(configs[i]);
                list.add(configs[i]);
            } else {
                list.addAll(next);
            }
            ++i;
        }
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Configuration config = (Configuration)it.next();
            this.configurations.add(config);
            if (!reject.contains(config)) continue;
            this.configurations.setReject(config);
        }
        this.configurations.validate();
        this.configurations.repaint();
        this.changeSelection();
        try {
            JSplitPane split = (JSplitPane)this.configurations.getParent().getParent().getParent().getParent();
            int loc = split.getDividerLocation();
            split.setDividerLocation(loc - 1);
            split.setDividerLocation(loc);
        }
        catch (Throwable split) {
            // empty catch block
        }
        State current = null;
        Iterator iter = list.iterator();
        int count = 0;
        if (blockStep) {
            while (iter.hasNext()) {
                Configuration configure = (Configuration)iter.next();
                current = configure.getCurrentState();
                if (configure.getBlockStack().size() <= 0 || ((Automaton)configure.getAutoStack().peek()).getInitialState() == current && configure.getBlockStack().size() <= 1) continue;
                if (configure.isAccept()) break;
                if (++count > 10000) {
                    int result = JOptionPane.showConfirmDialog(null, "JFLAP has generated 10000 configurations. Continue?");
                    switch (result) {
                        case 2: {
                            return;
                        }
                        case 1: {
                            return;
                        }
                    }
                }
                this.step(blockStep);
                break;
            }
        }
    }

    public void freeze() {
        Configuration[] configs = this.configurations.getSelected();
        if (configs.length == 0) {
            JOptionPane.showMessageDialog(this.configurations, NO_CONFIGURATION_ERROR, NO_CONFIGURATION_ERROR_TITLE, 0);
            return;
        }
        int i = 0;
        while (i < configs.length) {
            this.configurations.setFrozen(configs[i]);
            ++i;
        }
        this.configurations.deselectAll();
        this.configurations.repaint();
    }

    public void remove() {
        Configuration[] configs = this.configurations.getSelected();
        if (configs.length == 0) {
            JOptionPane.showMessageDialog(this.configurations, NO_CONFIGURATION_ERROR, NO_CONFIGURATION_ERROR_TITLE, 0);
            return;
        }
        int i = 0;
        while (i < configs.length) {
            this.configurations.remove(configs[i]);
            ++i;
        }
        this.configurations.validate();
        this.configurations.repaint();
    }

    public void focus() {
        State block;
        Configuration[] configs = this.configurations.getSelected();
        if (configs.length == 0) {
            JOptionPane.showMessageDialog(this.configurations, NO_CONFIGURATION_ERROR, NO_CONFIGURATION_ERROR_TITLE, 0);
            return;
        }
        if (configs.length > 1) {
            JOptionPane.showMessageDialog(this.configurations, FOCUS_CONFIGURATION_ERROR, FOCUS_CONFIGURATION_ERROR_TITLE, 0);
            return;
        }
        Configuration toFocus = configs[0];
        this.configurations.setFocused(toFocus);
        toFocus.setFocused(true);
        State parent = block = toFocus.getCurrentState().getParentBlock();
        Automaton checkTop = null;
        Stack heirarchy = new Stack();
        if (parent != null && (checkTop = this.findAutomaton(checkTop, heirarchy, parent, false)) != null) {
            this.drawer.setAutomaton(checkTop);
        }
        this.component.repaint();
    }

    public Automaton findAutomaton(Automaton checkTop, Stack heirarchy, State parent, boolean select) {
        Configuration[] configs = this.configurations.getConfigurations();
        int k = 0;
        while (k < configs.length) {
            if (configs[k].getFocused()) {
                Automaton temp = (Automaton)configs[k].getAutoStack().peek();
                return temp;
            }
            ++k;
        }
        while (parent != null) {
            if (select) {
                this.drawer.addSelected(parent);
            }
            if ((checkTop = (Automaton)this.simulator.getAutomaton().getBlockMap().get(parent.getInternalName())) != null) {
                while (!heirarchy.isEmpty()) {
                    State popped = (State)heirarchy.pop();
                    checkTop = (Automaton)checkTop.getBlockMap().get(popped.getInternalName());
                }
                break;
            }
            heirarchy.push(parent);
            parent = parent.getParentBlock();
        }
        return checkTop;
    }

    public void changeSelection() {
        this.drawer.clearSelected();
        Configuration[] configs = this.configurations.getConfigurations();
        boolean foundFocused = false;
        int i = 0;
        while (i < configs.length) {
            Configuration current = configs[i];
            foundFocused = this.setFocusIfNeeded(current, foundFocused);
            Stack blocks = (Stack)configs[i].getBlockStack().clone();
            if (!blocks.empty()) {
                State parent = (State)configs[i].getBlockStack().peek();
                int start = blocks.lastIndexOf(parent);
                while (start >= 0) {
                    parent = (State)blocks.get(start);
                    this.drawer.addSelected(parent);
                    --start;
                }
            }
            this.drawer.addSelected(configs[i].getCurrentState());
            ++i;
        }
        this.component.repaint();
    }

    private boolean setFocusIfNeeded(Configuration current, boolean foundFocused) {
        Configuration parentConfig = current.getParent();
        if (parentConfig == null) {
            return foundFocused;
        }
        if (parentConfig.getFocused()) {
            current.setFocused(true);
            if (!foundFocused) {
                this.configurations.setFocused(current);
                current.setFocused(true);
                Automaton setWith = (Automaton)current.getAutoStack().peek();
                this.drawer.setAutomaton(setWith);
                foundFocused = true;
            }
        }
        return foundFocused;
    }

    public void defocus() {
        Configuration[] configs = this.configurations.getConfigurations();
        int i = 0;
        while (i < configs.length) {
            if (configs[i].getFocused()) {
                this.configurations.defocus(configs[i]);
            }
            ++i;
        }
        this.drawer.setAutomaton(this.simulator.getAutomaton());
        this.drawer.invalidate();
        this.component.repaint();
    }

    public void thaw() {
        Configuration[] configs = this.configurations.getSelected();
        if (configs.length == 0) {
            JOptionPane.showMessageDialog(this.configurations, NO_CONFIGURATION_ERROR, NO_CONFIGURATION_ERROR_TITLE, 0);
            return;
        }
        int i = 0;
        while (i < configs.length) {
            this.configurations.setNormal(configs[i]);
            ++i;
        }
        this.configurations.deselectAll();
        this.configurations.repaint();
    }

    public void trace() {
        Configuration[] configs = this.configurations.getSelected();
        if (configs.length == 0) {
            JOptionPane.showMessageDialog(this.configurations, NO_CONFIGURATION_ERROR, NO_CONFIGURATION_ERROR_TITLE, 0);
            return;
        }
        int i = 0;
        while (i < configs.length) {
            TraceWindow window = (TraceWindow)this.configurationToTraceWindow.get(configs[i]);
            if (window == null) {
                this.configurationToTraceWindow.put(configs[i], new TraceWindow(configs[i]));
            } else {
                window.setVisible(true);
                window.toFront();
            }
            ++i;
        }
    }

    public boolean isTuringMachine() {
        return this.simulator instanceof TMSimulator;
    }

    public void configurationSelectionChange(ConfigurationSelectionEvent event) {
    }
}

