/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import automata.Automaton;
import automata.Configuration;
import gui.viewer.StateDrawer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import javax.swing.Icon;

public abstract class ConfigurationIcon
implements Icon {
    private Configuration configuration;
    private Automaton automaton;
    protected static final int STATE_RADIUS = 13;
    private static final StateDrawer STATE_DRAWER = new StateDrawer(13);
    private static final Point STATE_POINT = new Point(26, 13);
    private static final Point BB_POINT = new Point((int)(STATE_POINT.getX() * 3.5), (int)STATE_POINT.getY());
    protected static final Point RIGHT_STATE = new Point(39, 0);
    protected static final Point BELOW_STATE = new Point(0, 26);

    public ConfigurationIcon(Configuration configuration) {
        this.configuration = configuration;
        this.automaton = configuration.getCurrentState().getAutomaton();
    }

    public int getIconWidth() {
        return 400;
    }

    public int getIconHeight() {
        return 26;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(x, y);
        this.paintConfiguration(c, g2, this.getIconWidth(), this.getIconHeight());
        g2.translate(-x, -y);
    }

    public void paintConfiguration(Component c, Graphics2D g, int width, int height) {
        if (this.configuration.getCurrentState().getParentBlock() != null) {
            STATE_DRAWER.drawState(g, this.automaton, this.configuration.getCurrentState().getParentBlock(), STATE_POINT);
            STATE_DRAWER.drawState(g, this.automaton, this.configuration.getCurrentState(), BB_POINT);
        } else {
            STATE_DRAWER.drawState(g, this.automaton, this.configuration.getCurrentState(), STATE_POINT);
        }
    }
}

