/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import automata.Automaton;
import automata.Configuration;
import gui.sim.ConfigurationButton;
import gui.sim.ConfigurationSelectionEvent;
import gui.sim.ConfigurationSelectionListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import javax.swing.JPanel;

public class ConfigurationPane
extends JPanel
implements ActionListener {
    private Automaton automaton;
    private HashMap configurationToButtonMap = new HashMap();
    private HashSet selected = new HashSet();
    private transient HashSet selectionListeners = new HashSet();

    public ConfigurationPane(Automaton automaton) {
        this.automaton = automaton;
    }

    public void add(Configuration configuration) {
        this.add(configuration, 0);
    }

    public void add(Configuration configuration, int state) {
        if (this.contains(configuration)) {
            return;
        }
        ConfigurationButton button = new ConfigurationButton(configuration, state);
        this.configurationToButtonMap.put(configuration, button);
        this.add(button);
        button.addActionListener(this);
    }

    public int getState(Configuration configuration) {
        return ((ConfigurationButton)this.configurationToButtonMap.get((Object)configuration)).state;
    }

    public boolean contains(Configuration configuration) {
        return this.configurationToButtonMap.containsKey(configuration);
    }

    public void setReject(Configuration configuration) {
        ConfigurationButton button = (ConfigurationButton)this.configurationToButtonMap.get(configuration);
        if (button == null) {
            return;
        }
        if (button.state == 0) {
            button.setState(2);
        }
    }

    public void setFrozen(Configuration configuration) {
        ConfigurationButton button = (ConfigurationButton)this.configurationToButtonMap.get(configuration);
        if (button == null) {
            return;
        }
        if (button.state == 0) {
            button.setState(3);
        }
    }

    public void setFocused(Configuration configuration) {
        ConfigurationButton button = (ConfigurationButton)this.configurationToButtonMap.get(configuration);
        if (button == null) {
            return;
        }
        if (button.state == 0) {
            button.setState(4);
        }
    }

    public void defocus(Configuration configuration) {
        this.setNormal(configuration);
        Configuration parent = configuration;
        parent.setFocused(false);
        while (parent.getParent() != null) {
            parent = parent.getParent();
            parent.setFocused(false);
        }
    }

    public void setNormal(Configuration configuration) {
        ConfigurationButton button = (ConfigurationButton)this.configurationToButtonMap.get(configuration);
        if (button == null) {
            return;
        }
        if (button.state == 3) {
            button.setState(0);
        } else if (button.state == 4) {
            button.setState(0);
        }
    }

    public void remove(Configuration configuration) {
        Component comp = (Component)this.configurationToButtonMap.remove(configuration);
        if (comp == null) {
            return;
        }
        this.selected.remove(configuration);
        this.remove(comp);
    }

    public void clear() {
        this.configurationToButtonMap.clear();
        this.selected.clear();
        super.removeAll();
    }

    public void deselectAll() {
        this.selected.clear();
    }

    public Configuration[] getSelected() {
        return this.selected.toArray(new Configuration[0]);
    }

    public Configuration[] getConfigurations() {
        return this.configurationToButtonMap.keySet().toArray(new Configuration[0]);
    }

    public Configuration[] getValidConfigurations() {
        ArrayList<Configuration> list = new ArrayList<Configuration>();
        Iterator it = this.configurationToButtonMap.values().iterator();
        while (it.hasNext()) {
            ConfigurationButton button = (ConfigurationButton)it.next();
            if (button.state != 0 && button.state != 4) continue;
            list.add(button.getConfiguration());
        }
        return list.toArray(new Configuration[0]);
    }

    public void clearFinal() {
        ArrayList list = new ArrayList();
        list.addAll(this.configurationToButtonMap.values());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ConfigurationButton button = (ConfigurationButton)it.next();
            if (button.state != 1 && button.state != 2) continue;
            this.remove(button.getConfiguration());
        }
    }

    public void clearThawed() {
        ArrayList list = new ArrayList();
        list.addAll(this.configurationToButtonMap.values());
        Iterator it = list.iterator();
        while (it.hasNext()) {
            ConfigurationButton button = (ConfigurationButton)it.next();
            if (button.state == 3) continue;
            this.remove(button.getConfiguration());
        }
    }

    public void actionPerformed(ActionEvent e) {
        ConfigurationButton button = null;
        try {
            button = (ConfigurationButton)e.getSource();
        }
        catch (ClassCastException ex) {
            return;
        }
        Configuration config = button.getConfiguration();
        if (!this.configurationToButtonMap.containsKey(config)) {
            return;
        }
        if (button.isSelected()) {
            this.selected.add(config);
        } else {
            this.selected.remove(config);
        }
        this.distributeSelectionEvent(new ConfigurationSelectionEvent(this));
    }

    public void addSelectionListener(ConfigurationSelectionListener listener) {
        this.selectionListeners.add(listener);
    }

    public void removeSelectionListener(ConfigurationSelectionListener listener) {
        this.selectionListeners.remove(listener);
    }

    void distributeSelectionEvent(ConfigurationSelectionEvent event) {
        Iterator it = this.selectionListeners.iterator();
        while (it.hasNext()) {
            ConfigurationSelectionListener listener = (ConfigurationSelectionListener)it.next();
            listener.configurationSelectionChange(event);
        }
    }
}

