/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import gui.TooltipAction;
import gui.sim.ConfigurationController;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JToolBar;

public class ControlPanel
extends JToolBar {
    private boolean blockStep = false;
    private ConfigurationController controller;

    public ControlPanel(ConfigurationController controller) {
        this.controller = controller;
        this.initView();
    }

    public ConfigurationController getController() {
        return this.controller;
    }

    protected void initView() {
        this.add(new TooltipAction("Step", "Moves existing valid configurations to the next configurations."){

            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.controller.step(ControlPanel.this.blockStep);
            }
        });
        this.add(new TooltipAction("Reset", "Resets the simulation to start conditions."){

            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.controller.reset();
            }
        });
        if (this.controller.isTuringMachine()) {
            this.add(new AbstractAction("Focus"){

                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.controller.focus();
                }
            });
            this.add(new AbstractAction("Defocus"){

                public void actionPerformed(ActionEvent e) {
                    ControlPanel.this.controller.defocus();
                }
            });
        }
        this.add(new AbstractAction("Freeze"){

            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.controller.freeze();
            }
        });
        this.add(new AbstractAction("Thaw"){

            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.controller.thaw();
            }
        });
        this.add(new AbstractAction("Trace"){

            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.controller.trace();
            }
        });
        this.add(new AbstractAction("Remove"){

            public void actionPerformed(ActionEvent e) {
                ControlPanel.this.controller.remove();
            }
        });
    }

    public void setBlock(boolean step) {
        this.blockStep = step;
    }
}

