/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import automata.Automaton;
import automata.AutomatonSimulator;
import automata.Configuration;
import gui.SplitPaneFactory;
import gui.editor.ArrowDisplayOnlyTool;
import gui.environment.Environment;
import gui.sim.ConfigurationController;
import gui.sim.ConfigurationPane;
import gui.sim.ControlPanel;
import gui.viewer.AutomatonPane;
import gui.viewer.SelectionDrawer;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SimulatorPane
extends JPanel {
    private Automaton automaton;
    private AutomatonSimulator simulator;

    public SimulatorPane(Automaton automaton, AutomatonSimulator simulator, Configuration[] configurations, Environment env, boolean blockStep) {
        this.automaton = automaton;
        this.simulator = simulator;
        this.initView(configurations, env, blockStep);
    }

    private void initView(Configuration[] configs, final Environment env, boolean blockStep) {
        this.setLayout(new BorderLayout());
        SelectionDrawer drawer = new SelectionDrawer(this.automaton);
        AutomatonPane display = new AutomatonPane(drawer, true);
        ArrowDisplayOnlyTool arrow = new ArrowDisplayOnlyTool(display, drawer);
        display.addMouseListener(arrow);
        JPanel lower = new JPanel();
        lower.setLayout(new BorderLayout());
        JScrollPane scroller = new JScrollPane(22, 31);
        ConfigurationPane configurations = new ConfigurationPane(this.automaton);
        configurations.setLayout(new GridLayout(0, 4));
        int i = 0;
        while (i < configs.length) {
            configurations.add(configs[i]);
            ++i;
        }
        final ConfigurationController controller = new ConfigurationController(configurations, this.simulator, drawer, display);
        env.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent e) {
                if (env.contains(SimulatorPane.this)) {
                    return;
                }
                env.removeChangeListener(this);
                controller.cleanup();
            }
        });
        ControlPanel controlPanel = new ControlPanel(controller);
        controlPanel.setBlock(blockStep);
        scroller.getViewport().setView(configurations);
        lower.add((Component)scroller, "Center");
        lower.add((Component)controlPanel, "South");
        JSplitPane split = SplitPaneFactory.createSplit(env, false, 0.6, display, lower);
        this.add((Component)split, "Center");
    }

    public void setAutomaton(Automaton newAuto) {
        this.automaton = newAuto;
    }
}

