/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import automata.Configuration;
import automata.turing.TMConfiguration;
import automata.turing.Tape;
import gui.sim.ConfigurationIcon;
import gui.sim.Torn;
import gui.sim.TuringConstants;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics2D;

public class TMConfigurationIcon
extends ConfigurationIcon
implements TuringConstants {
    private TMConfiguration config;

    public TMConfigurationIcon(Configuration configuration) {
        super(configuration);
        this.config = (TMConfiguration)configuration;
    }

    public int getIconHeight() {
        return super.getIconHeight() + 25 * this.config.getTapes().length;
    }

    public void paintConfiguration(Component c, Graphics2D g, int width, int height) {
        if (c != null) {
            super.paintConfiguration(c, g, width, height);
        }
        float position = (float)TMConfigurationIcon.BELOW_STATE.y + 5.0f;
        int headx = TMConfigurationIcon.BELOW_STATE.x + width / 2;
        int heady = TMConfigurationIcon.BELOW_STATE.y + 5;
        Tape[] tapes = this.config.getTapes();
        int i = 0;
        while (i < tapes.length) {
            float tornHeight = Torn.paintString(g, String.valueOf(FIX) + tapes[i].getContents() + FIX, TMConfigurationIcon.BELOW_STATE.x, position, 0, width, true, true, tapes[i].getTapeHead() + FIX.length());
            g.setColor(Color.black);
            g.drawLine(headx, heady, headx - 4, heady - 4);
            g.drawLine(headx, heady, headx + 4, heady - 4);
            position += tornHeight + 8.0f;
            ++i;
        }
        position -= 8.0f;
    }
}

