/*
 * Decompiled with CFR 0.152.
 */
package gui.sim;

import automata.Configuration;
import gui.sim.ConfigurationIcon;
import gui.sim.ConfigurationIconFactory;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.LinkedList;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JScrollPane;

public class TraceWindow
extends JFrame {
    private static final int MAXHEIGHT = 400;

    public TraceWindow(Configuration last) {
        super("Traceback");
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add(TraceWindow.getPastPane(last));
        this.pack();
        if (this.getSize().height > 400) {
            this.setSize(this.getSize().width, 400);
        }
        this.setVisible(true);
    }

    public static JScrollPane getPastPane(Configuration configuration) {
        JScrollPane sp = new JScrollPane(new PastPane(configuration), 22, 31);
        sp.validate();
        if (sp.getSize().height > 400) {
            sp.setSize(sp.getSize().width, 400);
        }
        return sp;
    }

    public static PastPane getPastPaneNoScroll(Configuration configuration) {
        return new PastPane(configuration);
    }

    public static class PastPane
    extends JComponent {
        private Icon[] icons;
        private static final int ARROW_LENGTH = 20;

        public PastPane(Configuration last) {
            this.setConfiguration(last);
        }

        public void setConfiguration(Configuration last) {
            LinkedList<ConfigurationIcon> list = new LinkedList<ConfigurationIcon>();
            int height = 0;
            int width = 0;
            while (last != null) {
                ConfigurationIcon icon = ConfigurationIconFactory.iconForConfiguration(last);
                width = Math.max(width, icon.getIconWidth());
                height += icon.getIconHeight() + 20;
                list.add(icon);
                last = last.getParent();
            }
            this.icons = list.toArray(new Icon[0]);
            this.setPreferredSize(new Dimension(width, height));
        }

        public void paintComponent(Graphics g) {
            Rectangle visible = this.getVisibleRect();
            int height = 20 + this.icons[0].getIconHeight();
            int max = this.icons.length - 1 - visible.y / height;
            int min = this.icons.length - 1 - (visible.y + visible.height) / height;
            try {
                min = Math.max(min, 0);
                g = g.create();
                g.translate(0, height * (this.icons.length - 1 - max));
                int i = max;
                while (i >= min) {
                    this.drawArrow(g);
                    this.drawIcon(g, this.icons[i]);
                    --i;
                }
                g.dispose();
            }
            catch (Throwable e) {
                System.err.println(e);
            }
        }

        public final void drawArrow(Graphics g) {
            int center = this.getWidth() >> 1;
            g.setColor(Color.black);
            g.drawLine(center, 0, center, 20);
            g.drawLine(center, 20, center - 10, 10);
            g.drawLine(center, 20, center + 10, 10);
            g.translate(0, 20);
        }

        public final void drawIcon(Graphics g, Icon icon) {
            icon.paintIcon(this, g, this.getWidth() - icon.getIconWidth() >> 1, 0);
            g.translate(0, icon.getIconHeight());
        }
    }
}

