/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import gui.tree.DefaultNodeDrawer;
import java.awt.Color;
import java.awt.Graphics2D;
import java.util.WeakHashMap;
import javax.swing.tree.TreeNode;

public class SelectNodeDrawer
extends DefaultNodeDrawer {
    protected WeakHashMap selectedNodes = new WeakHashMap();

    public void draw(Graphics2D g, TreeNode node) {
        Color c = g.getColor();
        if (this.isSelected(node)) {
            g.setColor(c.darker());
        }
        super.draw(g, node);
        g.setColor(c);
    }

    public boolean isSelected(TreeNode node) {
        return this.selectedNodes.containsKey(node);
    }

    public void setSelected(TreeNode node, boolean select) {
        if (select) {
            this.selectedNodes.put(node, null);
        } else {
            this.selectedNodes.remove(node);
        }
    }

    public TreeNode[] getSelected() {
        return this.selectedNodes.keySet().toArray(new TreeNode[0]);
    }

    public void clearSelected() {
        this.selectedNodes.clear();
    }
}

