/*
 * Decompiled with CFR 0.152.
 */
package gui.tree;

import gui.tree.DefaultTreeDrawer;
import gui.tree.TreeDrawer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

public class TreePanel
extends JComponent {
    private TreeDrawer treeDrawer;

    public TreePanel(TreeModel tree) {
        this.treeDrawer = new DefaultTreeDrawer(tree);
    }

    public TreePanel(TreeDrawer drawer) {
        this.treeDrawer = drawer;
    }

    public TreeDrawer getTreeDrawer() {
        return this.treeDrawer;
    }

    public void setTreeDrawer(TreeDrawer drawer) {
        this.treeDrawer = drawer;
        this.repaint();
    }

    public void paintComponent(Graphics gr) {
        Graphics2D g = (Graphics2D)gr;
        super.paintComponent(g);
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setColor(Color.white);
        Dimension d = this.getSize();
        g.fillRect(0, 0, d.width, d.height);
        g.setColor(Color.black);
        this.treeDrawer.draw(g, d);
    }

    public TreeNode nodeAtPoint(Point2D point) {
        return this.treeDrawer.nodeAtPoint(point, this.getSize());
    }
}

