/*
 * Decompiled with CFR 0.152.
 */
package gui.viewer;

import automata.Automaton;
import automata.Note;
import automata.State;
import automata.Transition;
import automata.event.AutomataStateEvent;
import automata.event.AutomataStateListener;
import automata.event.AutomataTransitionEvent;
import automata.event.AutomataTransitionListener;
import automata.mealy.MooreMachine;
import gui.viewer.CurvedArrow;
import gui.viewer.InvisibleCurvedArrow;
import gui.viewer.MooreStateDrawer;
import gui.viewer.StateDrawer;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;

public class AutomatonDrawer {
    private Rectangle mySelectionBounds = new Rectangle(0, 0, -1, -1);
    private Automaton automaton;
    private boolean drawLabels = true;
    protected static final double ANGLE = 0.12566370614359174;
    private boolean valid = false;
    private boolean validBounds = false;
    private Rectangle cachedBounds = null;
    private HashMap arrowToTransitionMap = new HashMap();
    private HashMap transitionToArrowMap = new HashMap();
    private StateDrawer statedrawer = new StateDrawer();

    public AutomatonDrawer(Automaton automaton) {
        this.automaton = automaton;
        DrawerListener listener = new DrawerListener();
        this.getAutomaton().addStateListener(listener);
        this.getAutomaton().addTransitionListener(listener);
        if (automaton instanceof MooreMachine) {
            this.statedrawer = new MooreStateDrawer();
        }
    }

    public Automaton getAutomaton() {
        return this.automaton;
    }

    public void drawAutomaton(Graphics g2) {
        if (!this.valid) {
            this.refreshArrowMap();
        }
        Graphics2D g = (Graphics2D)g2.create();
        g.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g.setFont(g.getFont().deriveFont(12.0f));
        g.setColor(Color.black);
        this.drawTransitions(g);
        State[] states = this.automaton.getStates();
        int i = 0;
        while (i < states.length) {
            this.drawState(g, states[i]);
            ++i;
        }
        this.drawSelectionBox(g);
        g.dispose();
    }

    public Rectangle getBounds(State state) {
        int radius = this.statedrawer.getRadius();
        Point p = state.getPoint();
        int yAdd = state.getLabels().length * 15;
        if (this.getAutomaton().getInitialState() == state) {
            return new Rectangle(p.x - radius * 2, p.y - radius, radius * 3, radius * 2 + yAdd);
        }
        return new Rectangle(p.x - radius, p.y - radius, radius * 2, radius * 2 + yAdd);
    }

    public Rectangle getBounds(Transition transition) {
        if (!this.valid) {
            this.refreshArrowMap();
        }
        CurvedArrow arrow = (CurvedArrow)this.transitionToArrowMap.get(transition);
        Rectangle2D r = arrow.getBounds();
        return new Rectangle((int)r.getX(), (int)r.getY(), (int)r.getWidth(), (int)r.getHeight());
    }

    public Rectangle getBounds() {
        State[] states;
        if (this.validBounds) {
            return this.cachedBounds;
        }
        if (!this.valid) {
            this.refreshArrowMap();
        }
        if ((states = this.getAutomaton().getStates()).length == 0) {
            return null;
        }
        Rectangle rect = this.getBounds(states[0]);
        int i = 1;
        while (i < states.length) {
            rect.add(this.getBounds(states[i]));
            ++i;
        }
        ArrayList notes = this.getAutomaton().getNotes();
        int k = 0;
        while (k < notes.size()) {
            Note curNote = (Note)notes.get(k);
            Rectangle newBounds = new Rectangle(curNote.getAutoPoint(), new Dimension(curNote.getBounds().getSize()));
            rect.add(newBounds);
            ++k;
        }
        Iterator it = this.arrowToTransitionMap.keySet().iterator();
        while (it.hasNext()) {
            CurvedArrow arrow = (CurvedArrow)it.next();
            Rectangle2D arrowBounds = arrow.getBounds();
            rect.add(arrowBounds);
        }
        this.validBounds = true;
        this.cachedBounds = rect;
        return this.cachedBounds;
    }

    protected void drawState(Graphics g, State state) {
        this.statedrawer.drawState(g, this.getAutomaton(), state);
        if (this.drawLabels) {
            this.statedrawer.drawStateLabel(g, state, state.getPoint(), StateDrawer.STATE_COLOR);
        }
    }

    protected void drawTransitions(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        Set arrows = this.arrowToTransitionMap.keySet();
        Iterator it = arrows.iterator();
        while (it.hasNext()) {
            CurvedArrow arrow = (CurvedArrow)it.next();
            arrow.draw(g2);
        }
    }

    protected void drawSelectionBox(Graphics g) {
        g.drawRect(this.mySelectionBounds.x, this.mySelectionBounds.y, this.mySelectionBounds.width, this.mySelectionBounds.height);
    }

    private void refreshArrowMap() {
        if (this.automaton == null) {
            return;
        }
        State[] states = this.automaton.getStates();
        this.arrowToTransitionMap.clear();
        this.transitionToArrowMap.clear();
        int i = 0;
        while (i < states.length) {
            int j = i + 1;
            while (j < states.length) {
                float bottom;
                Transition[] itoj = this.automaton.getTransitionsFromStateToState(states[i], states[j]);
                Transition[] jtoi = this.automaton.getTransitionsFromStateToState(states[j], states[i]);
                float top = jtoi.length > 0 ? 0.5f : 0.0f;
                float f = bottom = itoj.length > 0 ? 0.5f : 0.0f;
                if (itoj.length + jtoi.length != 0) {
                    CurvedArrow arrow;
                    float curvy;
                    double angle = this.angle(states[i], states[j]);
                    Point fromI = this.pointOnState(states[i], angle - 0.12566370614359174);
                    Point fromJ = this.pointOnState(states[j], angle + Math.PI + 0.12566370614359174);
                    int n = 0;
                    while (n < itoj.length) {
                        curvy = top + (float)n;
                        arrow = n == 0 ? new CurvedArrow(fromI, fromJ, curvy) : new InvisibleCurvedArrow(fromI, fromJ, curvy);
                        arrow.setLabel(itoj[n].getDescription());
                        this.arrowToTransitionMap.put(arrow, itoj[n]);
                        this.transitionToArrowMap.put(itoj[n], arrow);
                        ++n;
                    }
                    fromI = this.pointOnState(states[i], angle + 0.12566370614359174);
                    fromJ = this.pointOnState(states[j], angle + Math.PI - 0.12566370614359174);
                    n = 0;
                    while (n < jtoi.length) {
                        curvy = bottom + (float)n;
                        arrow = n == 0 ? new CurvedArrow(fromJ, fromI, curvy) : new InvisibleCurvedArrow(fromJ, fromI, curvy);
                        String label = jtoi[n].getDescription();
                        arrow.setLabel(label);
                        this.arrowToTransitionMap.put(arrow, jtoi[n]);
                        this.transitionToArrowMap.put(jtoi[n], arrow);
                        ++n;
                    }
                }
                ++j;
            }
            Transition[] trans = this.automaton.getTransitionsFromStateToState(states[i], states[i]);
            if (trans.length != 0) {
                Point from = this.pointOnState(states[i], -1.046150353645401);
                Point to = this.pointOnState(states[i], -2.0954422999443922);
                int n = 0;
                while (n < trans.length) {
                    CurvedArrow arrow = n == 0 ? new CurvedArrow(from, to, -2.0f) : new InvisibleCurvedArrow(from, to, -2.0f - (float)n);
                    arrow.setLabel(trans[n].getDescription());
                    this.arrowToTransitionMap.put(arrow, trans[n]);
                    this.transitionToArrowMap.put(trans[n], arrow);
                    ++n;
                }
            }
            ++i;
        }
        this.valid = true;
    }

    protected Point getCenterIntersection(State state1, State state2) {
        return this.pointOnState(state1, this.angle(state1, state2));
    }

    private double angle(State state1, State state2) {
        Point p1 = state1.getPoint();
        Point p2 = state2.getPoint();
        double x = p2.x - p1.x;
        double y = p2.y - p1.y;
        return Math.atan2(y, x);
    }

    private Point pointOnState(State state, double angle) {
        Point point = new Point(state.getPoint());
        double x = Math.cos(angle) * 20.0;
        double y = Math.sin(angle) * 20.0;
        point.translate((int)x, (int)y);
        return point;
    }

    public void invalidate() {
        this.valid = false;
        this.invalidateBounds();
    }

    public void invalidateBounds() {
        this.validBounds = false;
    }

    public State stateAtPoint(Point point) {
        State[] states = this.getAutomaton().getStates();
        int i = states.length - 1;
        while (i >= 0) {
            if (point.distance(states[i].getPoint()) <= 20.0) {
                return states[i];
            }
            --i;
        }
        return null;
    }

    public Transition transitionAtPoint(Point point) {
        if (!this.valid) {
            this.refreshArrowMap();
        }
        Set arrows = this.arrowToTransitionMap.keySet();
        Iterator it = arrows.iterator();
        while (it.hasNext()) {
            CurvedArrow arrow = (CurvedArrow)it.next();
            if (!arrow.isNear(point, 2)) continue;
            return (Transition)this.arrowToTransitionMap.get(arrow);
        }
        return null;
    }

    protected StateDrawer getStateDrawer() {
        return this.statedrawer;
    }

    protected void transitionChange(AutomataTransitionEvent event) {
        this.invalidate();
    }

    protected void stateChange(AutomataStateEvent event) {
        if (event.isMove()) {
            this.invalidate();
        } else {
            this.invalidateBounds();
        }
    }

    protected CurvedArrow arrowForTransition(Transition transition) {
        return (CurvedArrow)this.transitionToArrowMap.get(transition);
    }

    public boolean doesDrawStateLabels() {
        return this.drawLabels;
    }

    public void shouldDrawStateLabels(boolean drawLabels) {
        this.drawLabels = drawLabels;
    }

    public void setAutomaton(Automaton newAuto) {
        if (newAuto == null) {
            return;
        }
        this.automaton = newAuto;
        this.invalidate();
    }

    public void setSelectionBounds(Rectangle bounds) {
        this.mySelectionBounds = bounds;
    }

    public Rectangle getSelectionBounds() {
        return this.mySelectionBounds;
    }

    private class DrawerListener
    implements AutomataStateListener,
    AutomataTransitionListener {
        private DrawerListener() {
        }

        public void automataTransitionChange(AutomataTransitionEvent event) {
            AutomatonDrawer.this.transitionChange(event);
        }

        public void automataStateChange(AutomataStateEvent event) {
            AutomatonDrawer.this.stateChange(event);
        }
    }
}

