/*
 * Decompiled with CFR 0.152.
 */
package gui.viewer;

import automata.Automaton;
import automata.Note;
import automata.State;
import automata.event.AutomataStateEvent;
import automata.event.AutomataStateListener;
import automata.event.AutomataTransitionEvent;
import automata.event.AutomataTransitionListener;
import gui.JMultiLineToolTip;
import gui.editor.EditorPane;
import gui.viewer.AutomatonDrawer;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.util.ArrayList;
import javax.swing.JPanel;
import javax.swing.JTable;
import javax.swing.JToolTip;
import javax.swing.Scrollable;

public class AutomatonPane
extends JPanel
implements Scrollable {
    private EditorPane myCreator;
    private Point tp = null;
    protected AutomatonDrawer drawer;
    public AffineTransform transform = new AffineTransform();
    private boolean adapt;
    private boolean transformNeedsReform = true;
    private JTable table;

    public AutomatonPane(AutomatonDrawer drawer) {
        this(drawer, true);
        this.setLayout(null);
    }

    public JToolTip createToolTip() {
        return new JMultiLineToolTip();
    }

    public Point getToolTipLocation(MouseEvent event) {
        try {
            return this.transformFromAutomatonToView(this.drawer.stateAtPoint(event.getPoint()).getPoint());
        }
        catch (NullPointerException e) {
            return null;
        }
    }

    public String getToolTipText(MouseEvent event) {
        if (!this.drawer.doesDrawStateLabels()) {
            State s = this.drawer.stateAtPoint(event.getPoint());
            if (s == null) {
                return null;
            }
            return s.getLabel();
        }
        return null;
    }

    public AutomatonPane(AutomatonDrawer drawer, boolean adapt) {
        this.drawer = drawer;
        this.adapt = adapt;
        this.setPreferredSize(new Dimension(400, 300));
        Listener listener = new Listener();
        drawer.getAutomaton().addStateListener(listener);
        drawer.getAutomaton().addTransitionListener(listener);
        this.addComponentListener(listener);
        this.setToolTipText("Beavis");
        this.setOpaque(true);
    }

    public AutomatonPane(Automaton automaton) {
        this(new AutomatonDrawer(automaton));
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.transformNeedsReform) {
            this.reformTransform(new Rectangle(this.getSize()));
        }
        g.setColor(Color.white);
        g.fillRect(0, 0, this.getSize().width, this.getSize().height);
        Graphics2D g2 = (Graphics2D)g;
        g2.transform(this.transform);
        this.drawer.drawAutomaton(g);
        ArrayList notes = this.getDrawer().getAutomaton().getNotes();
        int k = 0;
        while (k < notes.size()) {
            Note curNote = (Note)notes.get(k);
            curNote.updateView();
            ++k;
        }
    }

    public void printComponent(Graphics g) {
        boolean oldAdapt = this.adapt;
        this.adapt = true;
        this.reformTransform(g.getClipBounds());
        g.setColor(Color.white);
        g.fillRect(0, 0, g.getClipBounds().width, g.getClipBounds().height);
        Graphics2D g2 = (Graphics2D)g.create();
        g2.transform(this.transform);
        this.drawer.drawAutomaton(g2);
        this.adapt = oldAdapt;
        this.reformTransform(new Rectangle(this.getSize()));
    }

    protected Rectangle getAutomatonBounds() {
        Rectangle rect = this.drawer.getBounds();
        if (rect == null) {
            return new Rectangle(this.getSize());
        }
        return rect;
    }

    private void reformTransform(Rectangle viewBounds) {
        this.transformNeedsReform = false;
        Rectangle bounds = new Rectangle(this.getAutomatonBounds());
        if (!this.adapt) {
            Rectangle visible = this.getVisibleRect();
            Point viewportUpperLeft = new Point((int)((double)visible.x - this.transform.getTranslateX()), (int)((double)visible.y - this.transform.getTranslateY()));
            Point componentUpperLeft = new Point(Math.min(bounds.x, Math.min(0, viewportUpperLeft.x)), Math.min(bounds.y, Math.min(0, viewportUpperLeft.y)));
            this.transform = new AffineTransform();
            this.transform.translate(-componentUpperLeft.x, -componentUpperLeft.y);
            Dimension newSize = new Dimension(Math.max(bounds.width + bounds.x, viewportUpperLeft.x + visible.width) - componentUpperLeft.x, Math.max(bounds.height + bounds.y, viewportUpperLeft.y + visible.height) - componentUpperLeft.y);
            if (newSize.equals(this.getPreferredSize())) {
                return;
            }
            this.setPreferredSize(newSize);
            this.revalidate();
            this.scrollRectToVisible(visible);
            return;
        }
        this.transform = new AffineTransform();
        bounds.grow(20, 20);
        Rectangle ourBounds = viewBounds;
        double aRatio = bounds.getWidth() / bounds.getHeight();
        double vRatio = ourBounds.getWidth() / ourBounds.getHeight();
        if (aRatio > vRatio) {
            double targetHeight = bounds.getWidth() / vRatio;
            bounds.setRect(bounds.getX(), bounds.getY() - (targetHeight -= bounds.getHeight()) / 2.0, bounds.getWidth(), bounds.getHeight() + targetHeight);
        } else {
            double targetWidth = bounds.getHeight() * vRatio;
            bounds.setRect(bounds.getX() - (targetWidth -= bounds.getWidth()) / 2.0, bounds.getY(), bounds.getWidth() + targetWidth, bounds.getHeight());
        }
        double scale = ourBounds.getWidth() / bounds.getWidth();
        this.transform.scale(scale, scale);
        this.transform.translate(ourBounds.getX() - bounds.getX(), ourBounds.getY() - bounds.getY());
    }

    public void transformMouseEvent(MouseEvent event) {
        if (this.transformNeedsReform) {
            this.reformTransform(new Rectangle(this.getSize()));
        }
        Point point = new Point();
        Point ePoint = event.getPoint();
        try {
            this.transform.inverseTransform(ePoint, point);
            event.translatePoint(point.x - ePoint.x, point.y - ePoint.y);
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            // empty catch block
        }
    }

    public Point transformFromAutomatonToView(Point point) {
        return (Point)this.transform.transform(point, new Point());
    }

    public Point transformFromViewToAutomaton(Point point) {
        try {
            return (Point)this.transform.inverseTransform(point, new Point());
        }
        catch (NoninvertibleTransformException noninvertibleTransformException) {
            return new Point(point);
        }
    }

    public void processMouseEvent(MouseEvent event) {
        this.transformMouseEvent(event);
        super.processMouseEvent(event);
    }

    public void processMouseMotionEvent(MouseEvent event) {
        this.transformMouseEvent(event);
        super.processMouseMotionEvent(event);
    }

    public AutomatonDrawer getDrawer() {
        return this.drawer;
    }

    public Dimension getPreferredScrollableViewportSize() {
        return this.getPreferredSize();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 1 ? visibleRect.height : visibleRect.width;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 5;
    }

    public boolean getScrollableTracksViewportWidth() {
        if (this.adapt) {
            return true;
        }
        return this.getPreferredSize().width < this.getParent().getSize().width;
    }

    public boolean getScrollableTracksViewportHeight() {
        if (this.adapt) {
            return true;
        }
        return this.getPreferredSize().height < this.getParent().getSize().height;
    }

    public Point getAutomatonOrigin() {
        return new Point(-((int)this.transform.getTranslateX()), -((int)this.transform.getTranslateY()));
    }

    public void fitToBounds(int padding) {
        Rectangle viewBounds = this.getVisibleRect();
        Rectangle automatonBounds = this.drawer != null && this.drawer.getBounds() != null ? new Rectangle(this.drawer.getBounds()) : new Rectangle(0, 0);
        automatonBounds.grow(padding, padding);
        viewBounds.y = 0;
        viewBounds.x = 0;
        State[] states = this.drawer.getAutomaton().getStates();
        int i = 0;
        while (i < states.length) {
            Point p = states[i].getPoint();
            p.setLocation((p.getX() - automatonBounds.getX()) * (viewBounds.getWidth() / automatonBounds.getWidth()), (p.getY() - automatonBounds.getY()) * (viewBounds.getHeight() / automatonBounds.getHeight()));
            states[i].setPoint(p);
            ++i;
        }
    }

    public Component add(Component c) {
        if (c instanceof JTable) {
            this.table = (JTable)c;
        }
        return super.add(c);
    }

    public void setTablePoint(Point p) {
        this.tp = p;
    }

    public void doLayout() {
        try {
            super.doLayout();
            this.table.setLocation(this.tp);
        }
        catch (NullPointerException e) {
            super.doLayout();
        }
    }

    public void setAdapt(boolean newAdapt) {
        this.adapt = newAdapt;
        this.transformNeedsReform = true;
        this.repaint();
    }

    public boolean getAdapt() {
        return this.adapt;
    }

    public void setCreator(EditorPane pane) {
        this.myCreator = pane;
    }

    public EditorPane getCreator() {
        return this.myCreator;
    }

    private class Listener
    extends ComponentAdapter
    implements AutomataStateListener,
    AutomataTransitionListener {
        private Listener() {
        }

        public void automataTransitionChange(AutomataTransitionEvent e) {
            AutomatonPane.this.transformNeedsReform = true;
            AutomatonPane.this.repaint();
        }

        public void automataStateChange(AutomataStateEvent e) {
            AutomatonPane.this.transformNeedsReform = true;
            AutomatonPane.this.repaint();
        }

        public void componentResized(ComponentEvent e) {
            if (AutomatonPane.this.adapt) {
                AutomatonPane.this.transformNeedsReform = true;
            }
            AutomatonPane.this.repaint();
        }
    }
}

