/*
 * Decompiled with CFR 0.152.
 */
package gui.viewer;

import automata.Automaton;
import automata.State;
import automata.mealy.MooreMachine;
import gui.viewer.StateDrawer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Rectangle2D;

public class MooreStateDrawer
extends StateDrawer {
    public MooreStateDrawer() {
    }

    public MooreStateDrawer(int radius) {
        super(radius);
    }

    public void drawState(Graphics g, Automaton automaton, State state, Point point, Color color) {
        super.drawState(g, automaton, state, point, color);
        this.drawStateOutput(g, state, point, color);
    }

    private void drawStateOutput(Graphics g, State state, Point point, Color color) {
        int y;
        String output = ((MooreMachine)state.getAutomaton()).getStateDescription(state);
        int ascent = g.getFontMetrics().getAscent();
        int heights = 0;
        int textWidth = 0;
        Rectangle2D bounds = g.getFontMetrics().getStringBounds(output, g);
        textWidth = Math.max((int)bounds.getWidth(), textWidth);
        heights += ascent + 3;
        int width = textWidth + 6;
        int height = (heights -= 3) + 6;
        int x = point.x - (width >> 1) + 20;
        int baseline = y = point.y - 20 - height / 2;
        g.setColor(color);
        g.fillRect(x, y, width, height);
        g.setColor(Color.black);
        g.drawString(output, x + 3, baseline += ascent + 3);
        g.drawRect(x, y, width, height);
    }
}

