/*
 * Decompiled with CFR 0.152.
 */
package gui.viewer;

import automata.Automaton;
import automata.State;
import automata.Transition;
import automata.event.AutomataStateEvent;
import gui.viewer.AutomatonDrawer;
import gui.viewer.StateDrawer;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

public class SelectionDrawer
extends AutomatonDrawer {
    private Set selected = new HashSet();
    private Set selectedTransitions = new HashSet();
    protected static final Color SELECTED_COLOR = StateDrawer.STATE_COLOR.darker().darker();
    private Set listeners = new HashSet();

    public SelectionDrawer(Automaton automaton) {
        super(automaton);
    }

    protected void stateChange(AutomataStateEvent event) {
        if (event.isDelete()) {
            this.selected.remove(event.getState());
        }
        super.stateChange(event);
    }

    public void drawState(Graphics g, State state) {
        if (this.selected.contains(state)) {
            this.getStateDrawer().drawState(g, this.getAutomaton(), state, state.getPoint(), SELECTED_COLOR);
            if (this.doesDrawStateLabels()) {
                this.getStateDrawer().drawStateLabel(g, state, state.getPoint(), StateDrawer.STATE_COLOR);
            }
        } else {
            super.drawState(g, state);
        }
    }

    protected void drawTransitions(Graphics g) {
        Graphics2D g2 = (Graphics2D)g;
        super.drawTransitions(g);
        Iterator it = this.selectedTransitions.iterator();
        while (it.hasNext()) {
            Transition t = (Transition)it.next();
            try {
                this.arrowForTransition(t).drawHighlight(g2);
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    public void addSelected(State state) {
        if (!this.selected.contains(state)) {
            this.selected.add(state);
            this.distributeChangeEvent();
        }
    }

    public void removeSelected(State state) {
        if (this.selected.contains(state)) {
            this.selected.remove(state);
            this.distributeChangeEvent();
        }
    }

    public int numberSelected() {
        return this.selected.size();
    }

    public State[] getSelected() {
        return this.selected.toArray(new State[0]);
    }

    public boolean isSelected(State state) {
        return this.selected.contains(state);
    }

    public void clearSelected() {
        if (this.selected.size() + this.selectedTransitions.size() > 0) {
            this.selected.clear();
            this.selectedTransitions.clear();
            this.distributeChangeEvent();
        }
    }

    protected Set selected() {
        return this.selected;
    }

    protected Set selectedTransitions() {
        return this.selectedTransitions;
    }

    public void addSelected(Transition transition) {
        if (transition.getFromState().getAutomaton() != this.getAutomaton()) {
            throw new IllegalArgumentException("Transition to select not in correct automaton!");
        }
        if (!this.selectedTransitions.contains(transition)) {
            this.selectedTransitions.add(transition);
            this.distributeChangeEvent();
        }
    }

    public void removeSelected(Transition transition) {
        if (this.selectedTransitions.contains(transition)) {
            this.selectedTransitions.remove(transition);
            this.distributeChangeEvent();
        }
    }

    public int numberSelectedTransitions() {
        return this.selectedTransitions.size();
    }

    public Transition[] getSelectedTransitions() {
        return this.selectedTransitions.toArray(new Transition[0]);
    }

    public boolean isSelected(Transition transition) {
        return this.selectedTransitions.contains(transition);
    }

    public void clearSelectedTransitions() {
        this.selectedTransitions.clear();
    }

    public void addChangeListener(ChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void distributeChangeEvent() {
        ChangeEvent e = new ChangeEvent(this);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ((ChangeListener)it.next()).stateChanged(e);
        }
    }
}

