/*
 * Decompiled with CFR 0.152.
 */
package gui.viewer;

import automata.Automaton;
import automata.State;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.geom.Rectangle2D;

public class StateDrawer {
    private int radius = 20;
    public static final int STATE_RADIUS = 20;
    public static final Color STATE_COLOR = new Color(255, 255, 150);
    public static final int STATE_LABEL_PAD = 3;

    public StateDrawer() {
        this.radius = 20;
    }

    public StateDrawer(int radius) {
        this.radius = radius;
    }

    public void drawState(Graphics g, Automaton automaton, State state) {
        this.drawState(g, automaton, state, state.getPoint());
    }

    public void drawState(Graphics g, Automaton automaton, State state, Point point) {
        this.drawState(g, automaton, state, point, STATE_COLOR);
    }

    public void drawState(Graphics g, Automaton automaton, State state, Point point, Color color) {
        this.drawArea(g, automaton, state, point, color);
    }

    private void drawArea(Graphics g, Automaton automaton, State state, Point point, Color color) {
        this.drawBackground(g, state, point, color);
        g.setColor(Color.black);
        int dx = (int)g.getFontMetrics().getStringBounds(state.getName(), g).getWidth() >> 1;
        int dy = g.getFontMetrics().getAscent() >> 1;
        g.drawString(state.getName(), point.x - dx, point.y + dy);
        if (state.getInternalName() == null) {
            g.drawOval(point.x - this.radius, point.y - this.radius, 2 * this.radius, 2 * this.radius);
            if (automaton.isFinalState(state)) {
                g.drawOval(point.x - this.radius + 3, point.y - this.radius + 3, this.radius - 3 << 1, this.radius - 3 << 1);
            }
            if (automaton.getInitialState() == state) {
                int[] x = new int[]{point.x - this.radius, point.x - (this.radius << 1), point.x - (this.radius << 1)};
                int[] y = new int[]{point.y, point.y - this.radius, point.y + this.radius};
                g.setColor(Color.white);
                g.fillPolygon(x, y, 3);
                g.setColor(Color.black);
                g.drawPolygon(x, y, 3);
            }
        } else {
            Double temp = new Double((double)this.radius * 1.5);
            g.drawRect(point.x - this.radius, point.y - this.radius, 2 * this.radius, 2 * this.radius);
            if (automaton.isFinalState(state)) {
                g.drawRect(point.x - this.radius + 3, point.y - this.radius + 3, this.radius - 3 << 1, this.radius - 3 << 1);
            }
            if (automaton.getInitialState() == state) {
                int[] x = new int[]{point.x - this.radius, point.x - (this.radius << 1), point.x - (this.radius << 1)};
                int[] y = new int[]{point.y, point.y - this.radius, point.y + this.radius};
                g.setColor(Color.white);
                g.fillPolygon(x, y, 3);
                g.setColor(Color.black);
                g.drawPolygon(x, y, 3);
            }
        }
    }

    public void drawStateLabel(Graphics g, State state, Point point, Color color) {
        int y;
        String[] labels = state.getLabels();
        if (labels.length == 0) {
            return;
        }
        int ascent = g.getFontMetrics().getAscent();
        int heights = 0;
        int textWidth = 0;
        int i = 0;
        while (i < labels.length) {
            Rectangle2D bounds = g.getFontMetrics().getStringBounds(labels[i], g);
            textWidth = Math.max((int)bounds.getWidth(), textWidth);
            heights += ascent + 3;
            ++i;
        }
        int width = textWidth + 6;
        int height = (heights -= 3) + 6;
        int x = point.x - (width >> 1);
        int baseline = y = point.y + 20 - 3;
        g.setColor(color);
        g.fillRect(x, y, width, height);
        g.setColor(Color.black);
        int i2 = 0;
        while (i2 < labels.length) {
            g.drawString(labels[i2], x + 3, baseline += ascent + 3);
            ++i2;
        }
        g.drawRect(x, y, width, height);
    }

    public void drawBackground(Graphics g, State state, Point point, Color color) {
        g.setColor(color);
        if (state.isSelected()) {
            g.setColor(new Color(100, 200, 200));
        }
        if (state.getInternalName() == null) {
            g.fillOval(point.x - this.radius, point.y - this.radius, 2 * this.radius, 2 * this.radius);
        } else {
            g.fillRect(point.x - this.radius, point.y - this.radius, 2 * this.radius, 2 * this.radius);
        }
    }

    public int getRadius() {
        return this.radius;
    }
}

