/*
 * Decompiled with CFR 0.152.
 */
package pumping;

import java.io.Serializable;
import pumping.Case;
import pumping.PumpingLemma;

public abstract class ContextFreePumpingLemma
extends PumpingLemma
implements Serializable,
Cloneable {
    protected String u;
    protected String v;
    protected String x;
    protected String y;
    protected String z;

    public void reset() {
        this.m = -1;
        this.i = -1;
        this.w = "";
        this.u = "";
        this.v = "";
        this.x = "";
        this.y = "";
        this.z = "";
        this.clearDoneCases();
    }

    public boolean chooseDecomposition(int[] decomposition) {
        int uLength = decomposition[0];
        int vLength = decomposition[1];
        int xLength = decomposition[2];
        int yLength = decomposition[3];
        if (vLength + xLength + yLength > this.m || vLength + yLength < 1) {
            return false;
        }
        this.u = this.w.substring(0, uLength);
        this.v = this.w.substring(uLength, uLength + vLength);
        this.x = this.w.substring(uLength + vLength, uLength + vLength + xLength);
        this.y = this.w.substring(uLength + vLength + xLength, uLength + vLength + xLength + yLength);
        this.z = this.w.substring(uLength + vLength + xLength + yLength);
        this.chooseI();
        return true;
    }

    public boolean chooseDecomposition(int[] decomposition, int num) {
        this.i = num;
        int uLength = decomposition[0];
        int vLength = decomposition[1];
        int xLength = decomposition[2];
        int yLength = decomposition[3];
        if (vLength + xLength + yLength > this.m || vLength + yLength < 1) {
            return false;
        }
        this.u = this.w.substring(0, uLength);
        this.v = this.w.substring(uLength, uLength + vLength);
        this.x = this.w.substring(uLength + vLength, uLength + vLength + xLength);
        this.y = this.w.substring(uLength + vLength + xLength, uLength + vLength + xLength + yLength);
        this.z = this.w.substring(uLength + vLength + xLength + yLength);
        return true;
    }

    public String createPumpedString() {
        return String.valueOf(this.u) + ContextFreePumpingLemma.pumpString(this.v, this.getI()) + this.x + ContextFreePumpingLemma.pumpString(this.y, this.getI()) + this.z;
    }

    public String getU() {
        return this.u;
    }

    public String getV() {
        return this.v;
    }

    public String getX() {
        return this.x;
    }

    public String getY() {
        return this.y;
    }

    public String getZ() {
        return this.z;
    }

    public int addCase(int[] decomposition, int num) {
        if (!this.chooseDecomposition(decomposition)) {
            return -1;
        }
        int j = 0;
        while (j < this.myDoneCases.size()) {
            if (((Case)this.myDoneCases.get(j)).isCase(this.v, this.y)) {
                return j;
            }
            ++j;
        }
        j = 0;
        while (j < this.myAllCases.size()) {
            Case c = (Case)this.myAllCases.get(j);
            if (c.isCase(this.v, this.y)) {
                c.setI(num);
                c.setUserInput(decomposition);
                this.myDoneCases.add(c);
                return this.myAllCases.size();
            }
            ++j;
        }
        System.err.println("BUG FOUND: ContextFreePumpingLemma.addCase(int[], int)");
        return -1;
    }

    public boolean replaceCase(int[] decomposition, int num, int index) {
        Case c = (Case)this.myDoneCases.get(index);
        if (c.isCase(this.v, this.y)) {
            c.setI(num);
            c.setUserInput(decomposition);
            return true;
        }
        return false;
    }

    public boolean isInLang() {
        return false;
    }
}

