/*
 * Decompiled with CFR 0.152.
 */
package pumping;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Random;
import pumping.Case;

public abstract class PumpingLemma
implements Serializable {
    protected static String AB_STAR = "{<i>a</i>, <i>b</i>}*";
    protected static String NOT_EQUAL = "&#8800;";
    protected static String ELEMENT_OF = "&#8712;";
    protected static String GREATER_OR_EQ = "&#8805;";
    protected static String GREATER_THAN = "&#62;";
    protected static String LESS_THAN = "&#60;";
    protected static String LESS_OR_EQ = "&#8804;";
    protected static Random COIN = new Random();
    protected int m;
    protected String w;
    protected int i;
    protected ArrayList myAllCases;
    protected ArrayList myDoneCases = new ArrayList();
    protected int[] myRange;

    public PumpingLemma() {
        this.myAllCases = new ArrayList();
        this.setRange();
        this.reset();
        this.addCases();
    }

    protected static String pumpString(String s, int i) {
        StringBuffer sb = new StringBuffer();
        int n = i;
        while (n > 0) {
            sb.append(s);
            --n;
        }
        return sb.toString();
    }

    public void chooseM(int n) {
        this.reset();
        this.m = n;
        this.chooseW();
    }

    public String getW() {
        return this.w;
    }

    public int getI() {
        if (this.i == -1) {
            this.chooseI();
        }
        return this.i;
    }

    public int getM() {
        return this.m;
    }

    public void setI(int num) {
        this.i = num;
    }

    public abstract String getTitle();

    public abstract void reset();

    public abstract String getHTMLTitle();

    public abstract boolean chooseDecomposition(int[] var1);

    public abstract boolean chooseDecomposition(int[] var1, int var2);

    protected abstract void chooseW();

    public abstract void chooseI();

    public abstract String createPumpedString();

    public int numCasesTotal() {
        return this.myAllCases.size();
    }

    public void doAll() {
        int i = 0;
        while (i < this.myAllCases.size()) {
            if (!this.myDoneCases.contains(this.myAllCases.get(i))) {
                this.myDoneCases.add(this.myAllCases.get(i));
            }
            ++i;
        }
    }

    public void clearDoneCases() {
        this.myDoneCases.clear();
        int i = 0;
        while (i < this.myAllCases.size()) {
            ((Case)this.myAllCases.get(i)).reset();
            ++i;
        }
    }

    public void clearCase(int n) {
        ((Case)this.myDoneCases.remove(n)).reset();
    }

    public Case getCase(int index) {
        return (Case)this.myDoneCases.get(index);
    }

    public abstract int addCase(int[] var1, int var2);

    public abstract boolean replaceCase(int[] var1, int var2, int var3);

    public ArrayList getDoneDescriptions() {
        ArrayList<String> ret = new ArrayList<String>();
        int i = 0;
        while (i < this.myDoneCases.size()) {
            ret.add(this.myDoneCases.get(i).toString());
            ++i;
        }
        return ret;
    }

    protected abstract void addCases();

    protected abstract void setRange();

    public int[] getRange() {
        return this.myRange;
    }

    protected static int factorial(int n) {
        if (n <= 1) {
            return 1;
        }
        return n * PumpingLemma.factorial(n - 1);
    }

    protected static int flipCoin() {
        if (COIN.nextBoolean()) {
            return 0;
        }
        return 2;
    }

    public ArrayList getDoneCases() {
        return this.myDoneCases;
    }

    public abstract boolean isInLang();
}

