/*
 * Decompiled with CFR 0.152.
 */
package pumping;

import java.io.Serializable;
import pumping.Case;
import pumping.PumpingLemma;

public abstract class RegularPumpingLemma
extends PumpingLemma
implements Serializable,
Cloneable {
    protected String x;
    protected String y;
    protected String z;

    public void reset() {
        this.m = -1;
        this.i = -1;
        this.w = "";
        this.x = "";
        this.y = "";
        this.z = "";
        this.clearDoneCases();
    }

    public boolean chooseDecomposition(int[] decomposition, int num) {
        this.i = num;
        int xLength = decomposition[0];
        int yLength = decomposition[1];
        if (xLength + yLength > this.m || yLength < 1 || xLength < 0) {
            return false;
        }
        this.x = this.w.substring(0, xLength);
        this.y = this.w.substring(xLength, xLength + yLength);
        this.z = this.w.substring(xLength + yLength);
        return true;
    }

    public boolean chooseDecomposition(int[] decomposition) {
        int xLength = decomposition[0];
        int yLength = decomposition[1];
        if (xLength + yLength > this.m || yLength < 1 || xLength < 0) {
            return false;
        }
        this.x = this.w.substring(0, xLength);
        this.y = this.w.substring(xLength, xLength + yLength);
        this.z = this.w.substring(xLength + yLength);
        this.chooseI();
        return true;
    }

    public String createPumpedString() {
        return String.valueOf(this.x) + RegularPumpingLemma.pumpString(this.y, this.getI()) + this.z;
    }

    public String getX() {
        return this.x;
    }

    public String getY() {
        return this.y;
    }

    public String getZ() {
        return this.z;
    }

    public int addCase(int[] decomposition, int num) {
        if (!this.chooseDecomposition(decomposition)) {
            return -1;
        }
        int j = 0;
        while (j < this.myDoneCases.size()) {
            if (((Case)this.myDoneCases.get(j)).isCase(this.y, this.y)) {
                return j;
            }
            ++j;
        }
        j = 0;
        while (j < this.myAllCases.size()) {
            if (((Case)this.myAllCases.get(j)).isCase(this.y, this.y)) {
                Case c = (Case)this.myAllCases.get(j);
                c.setI(num);
                c.setUserInput(decomposition);
                this.myDoneCases.add(c);
                return this.myAllCases.size();
            }
            ++j;
        }
        System.err.println("BUG FOUND: ContextFreePumpingLemma.addCase(int[])");
        return -1;
    }

    public boolean replaceCase(int[] decomposition, int num, int index) {
        Case c = (Case)this.myDoneCases.get(index);
        if (c.isCase(this.y, this.y)) {
            c.setI(num);
            c.setUserInput(decomposition);
            return true;
        }
        return false;
    }

    protected void addCases() {
    }

    public boolean isInLang() {
        return false;
    }
}

