/*
 * Decompiled with CFR 0.152.
 */
package regular;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import regular.ExpressionChangeEvent;
import regular.ExpressionChangeListener;

public class RegularExpression
implements Serializable {
    private String string;
    private transient Set listeners = new HashSet();
    private Reference reference = null;

    public RegularExpression() {
        this("");
    }

    public RegularExpression(String string) {
        this.change(string);
    }

    public RegularExpression(RegularExpression expression) {
        this(expression.asString());
    }

    public String asString() {
        try {
            String old = (String)this.reference.get();
            if (old.equals(this.string)) {
                return this.string;
            }
            this.string = old;
            this.reference = null;
            this.distributeChangeEvent(old);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return this.string;
    }

    public String toString() {
        return this.asString();
    }

    private boolean areParenthesesBalanced(String string) {
        int count = 0;
        int i = 0;
        while (i < string.length()) {
            if (string.charAt(i) == '(') {
                ++count;
            } else if (string.charAt(i) == ')') {
                --count;
            }
            if (count < 0) {
                return false;
            }
            ++i;
        }
        return count == 0;
    }

    public void change(String string) {
        try {
            if (this.string.equals(string)) {
                return;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        String old = this.string;
        this.string = string;
        this.distributeChangeEvent(old);
    }

    public void change(Reference ref) {
        this.reference = ref;
    }

    public String asCheckedString() {
        this.string = this.asString();
        if (this.string.length() == 0) {
            throw new UnsupportedOperationException("The expression must be nonempty.");
        }
        if (!this.areParenthesesBalanced(this.string)) {
            throw new UnsupportedOperationException("The parentheses are unbalanced!");
        }
        switch (this.string.charAt(0)) {
            case ')': 
            case '*': 
            case '+': {
                throw new UnsupportedOperationException("Operators are poorly formatted.");
            }
        }
        int i = 1;
        while (i < this.string.length()) {
            char c = this.string.charAt(i);
            char p = this.string.charAt(i - 1);
            switch (c) {
                case '+': {
                    if (i == this.string.length() - 1) {
                        throw new UnsupportedOperationException("Operators are poorly formatted.");
                    }
                }
                case ')': 
                case '*': {
                    if (p != '(' && p != '+') break;
                    throw new UnsupportedOperationException("Operators are poorly formatted.");
                }
                case '!': {
                    if (p != '(' && p != '+') {
                        throw new UnsupportedOperationException("Lambda character must not cat with anything else.");
                    }
                    if (i == this.string.length() - 1 || (p = this.string.charAt(i + 1)) == ')' || p == '+' || p == '*') break;
                    throw new UnsupportedOperationException("Lambda character must not cat with anything else.");
                }
            }
            ++i;
        }
        return this.string;
    }

    public void addExpressionListener(ExpressionChangeListener listener) {
        this.listeners.add(listener);
    }

    public void removeExpressionListener(ExpressionChangeListener listener) {
        this.listeners.remove(listener);
    }

    protected void distributeChangeEvent(String old) {
        ExpressionChangeEvent e = new ExpressionChangeEvent(this, old);
        Iterator it = this.listeners.iterator();
        while (it.hasNext()) {
            ExpressionChangeListener l = (ExpressionChangeListener)it.next();
            l.expressionChanged(e);
        }
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        this.asString();
        out.defaultWriteObject();
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        this.listeners = new HashSet();
    }
}

